//OHSAT GAMES MEGATILER TUTORIAL - HUD, SOUND, & MAKING AN EXIT - https://www.ohsat.com/tutorial/megatiler/megatiler-6/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>
 
//array defines for tile usage 

#define SOLID_TILE 1    // barrier tile
#define SPAWN_TILE 4    //value for player sprite for use in array
#define EXIT_TILE 5     //value for door tile
#define COIN_TILE 6     //value for coin sprite

#define MAX_COINS 3     //max number of coins on the map

//tile measurement defines

#define TILESIZE 8      // pixel value tile size
#define MAP_WIDTH 8     // tile width
#define MAP_HEIGHT 8    // tile height

//Sprite animation defines

#define ANIM_DOWN 0
#define ANIM_UP 1
#define ANIM_SIDE 2

//defines for SFX

#define SFX_COIN 64
#define SFX_UNLOCK 65

// 0 is grass, 1 is solid, 4 is spawn/player, 5 is exit, 6 is coin.

u8 level1[8][8] = {
    {6, 0, 0, 0, 0, 0, 0, 6},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 1, 1, 0, 0, 0},
    {4, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {0, 0, 0, 0, 1, 0, 0, 0},
    {5, 0, 0, 0, 0, 0, 0, 6}
};

//globals

u8 x = 0;
u8 y = 0;
u8 t = 0;
u8 i = 0;
u8 coinNum = 0;
u8 coinsCollected = 0;
char hud_string[10] = "";


int getTileAt(u8 X, u8 Y);

typedef struct {
    u8 x;
    u8 y; 
} Point;

Point exitLocation = { 0 , 0 };
bool exitUnlocked = FALSE;

typedef enum { up, down, left, right, none } moveDirection;

typedef struct {
    Point pos;
    Point tilePos;
    int w; 
    int h;
    int health;
    bool moving;
    moveDirection dir;
    Sprite *sprite;
    char name[6];
} Entity;

Entity player = {{0, 0}, {0, 0}, 8, 8, 0, FALSE, none, NULL, "PLAYER"};

typedef struct
{
    Point pos;
    u8 w;
    u8 h;
    Sprite *sprite;
    u8 health;
} Coin;

Coin coins[MAX_COINS];
Coin *c = coins;
Coin *coinToCheck; 

void loadLevel();
void movePlayer(moveDirection Direction);
void myJoyHandler(u16 joy, u16 changed, u16 state);
void updateScoreDisplay();
void unlockExit();

int main()
{   
    //MUSIC
    
    //SFX
    XGM_setPCM(SFX_COIN, sfx_coin, sizeof(sfx_coin));
    XGM_setPCM(SFX_UNLOCK, sfx_unlock, sizeof(sfx_unlock));

    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
    updateScoreDisplay();
   
    while(1)
    {
        if(player.moving == TRUE){
        switch(player.dir){
            case up:
                player.pos.y -= 1;
                break;

            case down: 
                player.pos.y += 1;
                break;

            case left: 
                player.pos.x -= 1;
                break;

            case right: 
                player.pos.x += 1;
                break;

                break;
            default:
                break;
            }
        }

        SPR_update(); 

        if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0)
        {
            player.moving = FALSE;
            //check if player on exit tile
            if (exitUnlocked == TRUE
            && player.tilePos.x == exitLocation.x
            && player.tilePos.y == exitLocation.y
        )
            {
                /* do stuff: coming in final tutorial */
            }
            
        }
        
        SPR_setPosition(player.sprite, player.pos.x, player.pos.y);

        for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                    coinsCollected++;
                    XGM_startPlayPCM(SFX_COIN, 1, SOUND_PCM_CH2);
                    updateScoreDisplay();
                    if(coinsCollected == MAX_COINS){
                        unlockExit();
                    }

                }
                
            }
        }

        SYS_doVBlankProcess();
    }

    return 0;
}


int getTileAt(u8 X, u8 Y)
{
    
    return level1[Y][X];
}

void loadLevel()
{
    SPR_init();

    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            t = level1[y][x];

            if (t == SPAWN_TILE)
            {
                player.tilePos.x = x;
                player.tilePos.y = y;

                player.pos.x = x * TILESIZE;
                player.pos.y = y * TILESIZE;

                player.sprite = SPR_addSprite(&spr_player, player.pos.x, player.pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));

                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }
            else if (t == COIN_TILE)
            {
                if (coinNum < MAX_COINS)
                {
                    c = &coins[coinNum];
                    c->pos.x = x * TILESIZE;
                    c->pos.y = y * TILESIZE;
                    c->w = 8;
                    c->h = 8;
                    c->health = 1;
                    c->sprite = SPR_addSprite(&coin, c->pos.x, c->pos.y, TILE_ATTR(PAL2, 0, FALSE, FALSE));
                    coinNum++;

                    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
                }
                
            }
            
            else if (t == EXIT_TILE)
            {
                exitLocation.x = x;
                exitLocation.y = y;
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
            }

            else {
                VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
            }
        }
    }

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
    PAL_setPalette(PAL2, spr_player.palette->data, DMA);
}

void movePlayer(moveDirection Direction)
{
    if (!player.moving)
    {
        switch(Direction)
        {
            case up:
                if (player.tilePos.y > 0 &&
                    getTileAt(player.tilePos.x, player.tilePos.y - 1) != SOLID_TILE)
                {
                    player.tilePos.y--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_UP);
                }
                break;

            case down:
                if (player.tilePos.y < MAP_HEIGHT - 1 &&
                    getTileAt(player.tilePos.x, player.tilePos.y + 1) != SOLID_TILE)
                {
                    player.tilePos.y++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_DOWN);
                }
                break;

            case left:
                if (player.tilePos.x > 0 &&
                    getTileAt(player.tilePos.x - 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x--;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite, TRUE);
                }
                break;

            case right:
                if (player.tilePos.x < MAP_WIDTH - 1 &&
                    getTileAt(player.tilePos.x + 1, player.tilePos.y) != SOLID_TILE)
                {
                    player.tilePos.x++;
                    player.moving = TRUE;
                    player.dir = Direction;
                    SPR_setAnim(player.sprite, ANIM_SIDE);
                    SPR_setHFlip(player.sprite,FALSE);
                }
                break;

            default:
                break;
        }
    }
}

void myJoyHandler(u16 joy, u16 changed, u16 state)
{
    if (joy == JOY_1)
    {
        if (state & BUTTON_UP)
            movePlayer(up);
        else if (state & BUTTON_DOWN)
            movePlayer(down);
        else if (state & BUTTON_LEFT)
            movePlayer(left);
        else if (state & BUTTON_RIGHT)
            movePlayer(right);
    }
}

void updateScoreDisplay(){
    sprintf(hud_string, "SCORE: %d", coinsCollected);
    VDP_clearText(8, 0, 10);
    VDP_drawText(hud_string, 8, 0);
}

void unlockExit()
{
    exitUnlocked = TRUE;
    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, FALSE, FALSE, FALSE, 3), exitLocation.x, exitLocation.y);
    XGM_startPlayPCM(SFX_UNLOCK, 1, SOUND_PCM_CH2);
}

////////////////////NOTES////////////////////

/*

1. Create a HUD element, hud_string, and use a sprintf() function to display the score

We'll declare the following globals

u8 coinsCollected = 0;
char hud_string[10] = "";

Then we'll make a function called updateScoreDisplay();

I forward-declared it up top and then wrote the function below. 

void updateScoreDisplay()
{
    sprintf(hud_string, "SCORE: %d", coinsCollected);
    VDP_clearText(8, 0, 10);
    VDP_drawText(hud_string, 8, 0);
}

You can hover your mouse of the VDP_clearText and VDP_drawText functions to see what the parameters are
but at this point you probably understand what the values correlate to. 

The same is likely true for sprintf(). The expression inside references the hud_string character array.
The character limit is 10 so I doubt we're going to have gigantic score totals. 

2. Update our while(1) loop and main() function to make sure the score displays on screen

Simply add updateScoreDisplay(); to the main() function and then we'll modify our while(1) loop 
to incorporate the score display and have it happen once we've done the boundary check on the player and coin sprites. 

main() reference:

int main()
{   
    JOY_init();
    JOY_setEventHandler(&myJoyHandler);
    loadLevel();
    updateScoreDisplay();

while(1) loop reference: 

       for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                    coinsCollected++;
                    updateScoreDisplay();
                }
                
            }
        }

3. Adding sound effects for exiting a door and picking up a coin

I'm going to paste the code below so you see the difference between the OHSAT tutorial and my code
as this was done using version SGDK 2.0 and his was done using pre-1.7

OHSAT Tutorial 

WAV sfx_coin "coin.wav" 0
WAV sfx_unlock "unlock.wav" 0

My code

WAV sfx_coin "SFX/coin.wav" PCM 
WAV sfx_unlock "SFX/unlock.wav" PCM 

If you were using a 0 instead of PCM at the end you would have received a compile error in Terminal. 

We'll add two #defines SFX_COIN and SFX_UNLOCK with values of 64 and 65 respectively. 
When you hover your mouse over XGM_setPCM() function it explains the separation of indexes between music and SFX. 

At the beginning of main(), we're going to add our SFX using the XGM_setPCM() function.

XGM_setPCM(SFX_COIN, sfx_coin, sizeof(sfx_coin));
XGM_setPCM(SFX_UNLOCK, sfx_unlock, sizeof(sfx_unlock));

Then we need to add a line below coinsCollected++ to ensure the SFX plays upon picking up a coin.

XGM_startPlayPCM(SFX_COIN, 1, SOUND_PCM_CH2);

Here's the for() statement in the while(1) loop for reference. 

        for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                    coinsCollected++;
                    XGM_startPlayPCM(SFX_COIN, 1, SOUND_PCM_CH2);
                    updateScoreDisplay();
                }
                
            }
        }

4. Adding an Exit tile and a corresponding SFX 

I added a #define EXIT_TILE with a value of 5 as this was what OHSAT had mentioned earlier. 

I chose to put the exit tile in the bottom-left corner. 

Next, we're going to add the helper functions used in the OHSAT tutorial. 
These will go above main(). 

Point exitLocation = { 0 , 0 };
bool exitUnlocked = FALSE;

Since this is referencing the Point struct, I put these lines at the bottom of that. 

typedef struct {
    u8 x;
    u8 y; 
} Point;

Point exitLocation = { 0 , 0 };
bool exitUnlocked = FALSE;

Next, we're going to add the exit tile code to our loadLevel() function using an else if() statement

else if (t == EXIT_TILE)
{
    exitLocation.x = x;
    exitLocation.y = y;
    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, 1), x, y);
}

The tutorial uses this code to draw a grass tile at a specific x/y position until the condition to unlock the exit tile is met. 

To meet that condition we're going to write a function called void unlockExit() to accomplish this. 

void unlockExit()
{
    exitUnlocked = TRUE;
    VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, FALSE, FALSE, FALSE, 3), exitLocation.x, exitLocation.y);
    XGM_startPlayPCM(SFX_UNLOCK, 1, SOUND_PCM_CH2);
}

We'll include an if() statement in the for() statement we used in the while(1) loop. 

The expression in the if() statement is the following. 

if(coinsCollected == MAX_COINS){} and statement is the unlockExit() function we just made. 

        for (i = 0; i < MAX_COINS; i++)
        {
            coinToCheck = &coins[i];
            if ((player.pos.x < coinToCheck->pos.x + coinToCheck->w 
                && player.pos.x + player.w > coinToCheck->pos.x 
                && player.pos.y <   coinToCheck->pos.y + coinToCheck->h 
                && player.pos.y + player.h > coinToCheck->pos.y) == TRUE)
            {
                if (coinToCheck->health >0)
                {
                    coinToCheck->health = 0;
                    SPR_setVisibility(coinToCheck->sprite, HIDDEN);
                    coinsCollected++;
                    XGM_startPlayPCM(SFX_COIN, 1, SOUND_PCM_CH2);
                    updateScoreDisplay();
                    if(coinsCollected == MAX_COINS){
                        unlockExit();
                    }

                }
                
            }
        }



5. Adding an if-condition to player.moving = FALSE

The last OHSAT tutorial will finish explaining what to do but here's how it looks in context. 

        if (player.pos.x % TILESIZE == 0 && player.pos.y % TILESIZE == 0)
        {
            player.moving = FALSE;
            //check if player on exit tile
            if (exitUnlocked == TRUE
            && player.tilePos.x == exitLocation.x
            && player.tilePos.y == exitLocation.y
        )
            {
                //do stuff: coming in final tutorial 
            }
            
        }

The long and short is we're going to add code to progress to the next level upon touching the exit door. 

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

1. I'm thinking of making some simple assets to make this into a Chip's Challenge kind of game. 
2. I may expand the map size to better incorporate a second player. We'll see what happens. 

*/

///////////ERROR HANDLING////////////////////

/*



*/